/****** Object:  StoredProcedure [dbo].[P_PDV_VD_IT_REPROCESSAR_VLR_DESC_RATEIO]    Script Date: 04/08/2014 09:57:57 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_IT_REPROCESSAR_VLR_DESC_RATEIO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_IT_REPROCESSAR_VLR_DESC_RATEIO]
GO
GO
GO
--Versao 2939
--EXEC P_PDV_VD_IT_REPROCESSAR_VLR_DESC_RATEIO 0,0,66,'2018-01-02'
CREATE PROCEDURE [dbo].[P_PDV_VD_IT_REPROCESSAR_VLR_DESC_RATEIO] (@MES INT, 
																  @ANO INT, 
																  @CD_FILIAL_PAR INT=0,
																  @DT_PROC DATETIME=NULL) WITH ENCRYPTION AS

DECLARE @CD_VD INT;
DECLARE @CD_IT INT;
DECLARE @TIRA_POE MONEY;
DECLARE @TIRA_POE_LOOP MONEY;
DECLARE @DT_INI DATETIME;
DECLARE @DT_FIM DATETIME;
DECLARE @DIA DATETIME;
DECLARE @CD_FILIAL AS INT;
DECLARE @AGORA DATETIME;
DECLARE @CD_EMP INT;
declare @Abate money;

CREATE TABLE #Tbl (CD_EMP INT, CD_FILIAL INT, CD_VD INT)

SET  @CD_EMP = 1

SET NOCOUNT ON
IF @DT_PROC IS NULL
BEGIN
	IF @ANO IS NULL OR @MES IS NULL
		begin
			SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
		end

	SET @DT_INI = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+@MES)) + '01')) ;
	SET @DT_FIM = dbo.F_FINAL_MES (@DT_INI) ;

	--RODA SO ATE hoje
	IF  @DT_FIM > dbo.F_HOJE()
	BEGIN
		SET @DT_FIM = dbo.F_HOJE() --1 
	END
END 
ELSE
BEGIN
	SET @DT_INI = @DT_PROC;
	SET @DT_FIM = @DT_PROC
END

DECLARE cFilial CURSOR FAST_FORWARD READ_ONLY FOR 
SELECT  
 	CD_FILIAL
FROM 
	PRC_FILIAL
WHERE 
	CD_EMP = 1  
	AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
OPEN CFILIAL
FETCH NEXT FROM cFilial INTO @CD_FILIAL	

	WHILE @@FETCH_STATUS=0
	BEGIN
		SET @DIA = @DT_INI
		WHILE @DT_FIM >= @DIA
			begin
				PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' -  Processando dia  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
			    --Buscando vendas com diferenca
				INSERT INTO #Tbl			
				SELECT 
					PDV_VD.CD_EMP,
					PDV_VD.CD_FILIAL,
					PDV_VD.CD_VD
				FROM
					PDV_VD_IT 
					INNER JOIN PDV_VD ON
					PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
					PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
					PDV_VD_IT.CD_VD = PDV_VD.CD_VD 
				WHERE
					PDV_VD.CD_EMP = @CD_EMP 
					AND PDV_VD.CD_FILIAL = @CD_FILIAL
					AND PDV_VD.DT_VD = @DIA
					AND PDV_VD.VLR_DESC > 0  
					AND PDV_VD_IT.ST_IT=1
				GROUP BY
					PDV_VD.CD_EMP,
					PDV_VD.CD_FILIAL,
					PDV_VD.CD_VD,
					PDV_VD.VLR_DESC
				HAVING  
					SUM(PDV_VD_IT.VLR_DESC_TOT_RAT) <> PDV_VD.VLR_DESC
				UNION 
				SELECT 
					PDV_VD.CD_EMP,
					PDV_VD.CD_FILIAL,
					PDV_VD.CD_VD
				FROM
					PDV_VD_IT 
					INNER JOIN PDV_VD ON
					PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
					PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
					PDV_VD_IT.CD_VD = PDV_VD.CD_VD 
				WHERE
					PDV_VD.CD_EMP = @CD_EMP 
					AND PDV_VD.CD_FILIAL = @CD_FILIAL
					AND PDV_VD.DT_VD = @DIA
					AND PDV_VD.VLR_DESC > 0  
					AND PDV_VD_IT.ST_IT=1
				GROUP BY
					PDV_VD.CD_EMP,
					PDV_VD.CD_FILIAL,
					PDV_VD.CD_VD,
					PDV_VD.VLR_DESC,
					TOT_IT
				HAVING  
					SUM(PDV_VD_IT.VLR_DESC_TOT_RAT) > PDV_VD_IT.TOT_IT;									
			
				--Se tem movimento para processar no dia
				IF EXISTS (SELECT
						 top 1 CD_EMP 
					   FROM
					      #Tbl)
					begin
						--PRINT ' Dia com valores:  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
						--Zerando rateios
						UPDATE
							PDV_VD_IT
						SET 
							VLR_DESC_TOT_RAT =  0 
						FROM
							PDV_VD_IT 
							INNER JOIN PDV_VD ON
							PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
							PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
							PDV_VD_IT.CD_VD = PDV_VD.CD_VD 
							INNER JOIN #Tbl v ON
							PDV_VD.CD_EMP = v.CD_EMP AND
							PDV_VD.CD_FILIAL = v.CD_FILIAL AND
							PDV_VD.CD_VD = v.CD_VD 
						--Fim 
				
						--Atualizando vendas selecionadas
						UPDATE
							PDV_VD_IT
						SET 
							--VLR_DESC_TOT_RAT =  PDV_VD ((PDV_VD_IT.QT_IT * PDV_VD_IT.VLR_IT) / PDV_VD.VLR_VD) * VLR_DESC,2) 
												-->Valor do item ************************************  / Valor da venda sem desc. itens          *  Valor desc cabecalho
							--VLR_DESC_TOT_RAT = round(round(((round( ((VLR_IT*QT_IT) * (1-(TX_DESC/100.0000))),2)) / (PDV_VD.VLR_VD- PDV_VD.VLR_DESC_ITENS) ),2) *  PDV_VD.VLR_DESC,2)
							VLR_DESC_TOT_RAT = round( (((VLR_IT*QT_IT) * (1-(TX_DESC/100.000)) )/ (PDV_VD.VLR_VD- PDV_VD.VLR_DESC_ITENS) )*  PDV_VD.VLR_DESC,2)
						FROM
							PDV_VD_IT 
							INNER JOIN PDV_VD ON
							PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
							PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
							PDV_VD_IT.CD_VD = PDV_VD.CD_VD 
							INNER JOIN #Tbl v ON
							PDV_VD.CD_EMP = v.CD_EMP AND
							PDV_VD.CD_FILIAL = v.CD_FILIAL AND
							PDV_VD.CD_VD = v.CD_VD 
						--Fim 
					    
						DECLARE cVendas CURSOR   FOR 	
						SELECT 
							PDV_VD_IT.CD_VD,
							PDV_VD.VLR_DESC - SUM(ROUND(PDV_VD_IT.VLR_DESC_TOT_RAT,2))VLR_DESC_TOT_RAT 
						FROM
							PDV_VD_IT 
							INNER JOIN PDV_VD ON
							PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
							PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
							PDV_VD_IT.CD_VD = PDV_VD.CD_VD 
							INNER JOIN #Tbl v ON
							PDV_VD.CD_EMP = v.CD_EMP AND
							PDV_VD.CD_FILIAL = v.CD_FILIAL AND
							PDV_VD.CD_VD = v.CD_VD 
						WHERE
							PDV_VD_IT.ST_IT = 1
						GROUP BY
							PDV_VD_IT.CD_VD,
							PDV_VD.VLR_DESC
						HAVING  
							SUM(ROUND(PDV_VD_IT.VLR_DESC_TOT_RAT,2)) <> PDV_VD.VLR_DESC;
				 
						OPEN cVendas
						FETCH NEXT FROM cVendas INTO @CD_VD, @TIRA_POE 
							WHILE @@FETCH_STATUS=0
							  begin 
							 
								print 'Corrigindo a venda ' + convert(varchar,@CD_VD) + ' Dif. '+ convert(varchar,@TIRA_POE) ;

								SET @TIRA_POE_LOOP = @TIRA_POE

								WHILE @TIRA_POE_LOOP <> 0
									BEGIN

									     if @tira_poe > 0
										  set @Abate = 0.01
										
										if @tira_poe < 0
										  set @Abate = -0.01;

										Print @Abate

										SET @CD_IT = (SELECT 
														TOP 1 CD_IT 
			 										FROM 
														PDV_VD_IT INNER JOIN #Tbl v ON
														PDV_VD_IT.CD_EMP = v.CD_EMP AND
														PDV_VD_IT.CD_FILIAL = v.CD_FILIAL AND
														PDV_VD_IT.CD_VD = v.CD_VD 
													WHERE
														PDV_VD_IT.CD_EMP = @CD_EMP 
														AND PDV_VD_IT.CD_FILIAL = @CD_FILIAL
														AND PDV_VD_IT.CD_VD = @CD_VD
														AND PDV_VD_IT.ST_IT = 1
														AND PDV_VD_IT.TOT_IT > ABS(@Abate)
													ORDER BY  
														VLR_DESC_TOT_RAT DESC );
										UPDATE 
											PDV_VD_IT
										SET
											VLR_DESC_TOT_RAT= (VLR_DESC_TOT_RAT + @Abate)
										FROM
											PDV_VD_IT
										WHERE
											PDV_VD_IT.CD_EMP = @CD_EMP 
											AND PDV_VD_IT.CD_FILIAL = @CD_FILIAL
											AND PDV_VD_IT.CD_VD = @CD_VD
											AND PDV_VD_IT.CD_IT = @CD_IT 
											  
										SET @TIRA_POE_LOOP = (@TIRA_POE_LOOP - @Abate)

									END	
								 
								FETCH NEXT FROM cVendas INTO @CD_VD, @TIRA_POE;
						  end
						  CLOSE cVendas;
						  DEALLOCATE cVendas; 
				end	
				TRUNCATE TABLE #Tbl;	
 				SELECT @DIA = @DIA + 1
			end		
		FETCH NEXT FROM  cFilial INTO @CD_FILIAL 
	END

CLOSE cFilial;
DEALLOCATE cFilial;


